# MT1.2 Muddy shores : Indicative distribution map

This archive contains information for *MT1.2 Muddy Shorelines*, a ecosystem functional group (EFG, level 3) of the [IUCN Global Ecosystem Typology](https://global-ecosystems.org/).

## General notes on maps

The maps show areas of the world containing major or minor occurrences of *MT1.2 Muddy Shorelines*. Minor occurrences are areas where an EFG is scattered in patches within matrices of others or where they occur in substantial areas but only within a segment of a larger region.

The maps were designed to be indicative of global distribution patterns and are not intended to represent fine-scale patterns. Given bounds of resolution and accuracy of source data, the maps should be used to query which EFG are likely to occur within areas, rather than which occur at particular point locations.

## Methods for this map

Tidal flats were mapped directly from remote sensing time series and aggregated to 1 degree spatial resolution by Murray et al. (2019). Major occurrences were mapped in 1-degree cells with >200km2 mudflat extent, and minor occurrences were mapped in cells with 5-200km2 mudflat extent.

For online visualization and navigation visit:

https://global-ecosystems.org/explore/groups/MT1.2

## Citation

### For functional group profile

MJ Bishop, NJ Murray, SE Swearer and DA Keith (2022) MT1.2 Muddy Shorelines. In: Keith, D.A., Ferrer-Paris, J.R., Nicholson, E. et al. (2022). A function-based typology for Earth’s ecosystems – Appendix S4. The IUCN Global Ecosystem Typology v2.1: Descriptive profiles for Biomes and Ecosystem Functional Groups. Nature DOI:10.1038/s41586-022-05318-4. Content version: v2.1, 2022-04-06 05:02:01.

### For this data set

NJ Murray, DA Keith and JR Ferrer-Paris  (2023). Indicative distribution map for Ecosystem Functional Group MT1.2 Muddy Shorelines [Data set]. Zenodo. http://doi.org/10.5281/zenodo.10067965

## Contents of this data set

- `README.md` 		 This file
- `MT1_2_Muddy_shores.xml` 		 Profile text for the funcional group (XML format)
- `MT1.2.IM.orig_v1.0.tif` 		 Indicative map (raster layer, GeoTIFF format)
- `MT1.2.IM.orig_v1.0.json.bz2` 		 Indicative map (vector layer, GeoJSON format)
