function [H, m, p, P0, P1] = problem_setup(whichone)

    if strcmp(whichone, 'MSD')

        g = 50;
        mas = 100*ones(g,1);
        k1  = 2*ones(g-1,1);
        k2  = 2*ones(g,1); k2(1) = 4; k2(g) = 4;
        d1  = 5*ones(g-1,1);
        d2  = 5*ones(g,1); d2(1) = 10;d2(g) = 10;

        [E,A,B,~,~,~] = msd_ind3(g,mas,k1,k2,d1,d2);

        C = ones(1,2*g+1);

        %number of inputs
        m = size(B,2);

        % number of outputs
        p = size(C,1);

        % put together the system realization in descriptor format
        % sys = dss(A,B,C,0,E);

        % the coefficients of the polynomial part

        P0 =  0.5;
        P1 = 0.001;
        % P_true{3} = zeros(p,m);

        H = @(omega) C*((omega*E-A)\B)+P1*omega;

    elseif strcmp(whichone, 'NSE')
        data = load('matxprt_Re20_NVNP416825418.mat');  % load the matrices
        %% % this comes from an NSE linearization -- there is two variables (v, p)
        %% % of dimension NV and NP
        A = data.A;  % NVxNV  -- system matrix
        B = data.B;  % (NV+NP)x1 -- the input matrix in th
        dB = data.dB;  % (NV+NP)x1 -- the input derivative matrix
        % Cv = data.Cv;  % 2x(NV+NP) -- take v-measurements -- two components
        Cp = data.Cp;  % 1x(NV+NP) -- take p-measurements
        M = data.M;    % NVxNV -- mass matrix =/= identity
        J = data.J;    % NPxNV -- the algebraic constraint on v
        zpp = data.zpp;  % NPxNP -- zero matrix (for convenience)
        zvp = data.zvp;  % NPxNV -- zero matrix (for convenience)

        calE = [M, zvp; zvp', zpp]; % the full system matrices for Ex'=Ax+Bu+dBu' with x=(v,p) 
        calA = [A, J'; -J, zpp]; % the full system matrices for Ex'=Ax+Bu+dBu' with x=(v,p)

        % fullC = [Cv; Cp]; % concatenating the outputs
        C = Cp;

        %number of inputs
        m = size(B,2);

        % number of outputs
        p = size(C,1);

        H = @(s) C * ((calA - s * calE) \ (B + s * dB));  % transfer function handle
        % it's encoded in the matrices -- but how to compute??
        P0 = NaN;
        P1 = NaN;
    end
end
