clear
close
% setup plots
set(0,'DefaultFigurePosition', [100 100 1000 400]);
set(0,'defaultlinelinewidth',3)
set(0,'defaultlinemarkersize',20)
set(0,'defaultaxesfontsize',20)
% %% COLORS
syscolors = turbo(4); % FOM, Loewner, Loewner-new, CAA 
errcolors = cool(3);  % Loewner, Loewner-new, CAA

problem = 'NSE';
problem = 'MSD';

load(sprintf('data/Loewner_%s.mat', problem))
load(sprintf('data/CAA_%s.mat', problem))

if strcmp(problem, 'NSE')
       problem = 'Oseen';
       abstfname = '$|H_{\mathsf{OS}}|$';
       relerrtfname = '$|H_{\mathsf{OS}}-\hat H_{\mathsf{OS}}|$';
else
       abstfname = '$|H_{\mathsf{MSD}}|$';
       relerrtfname = '$|H_{\mathsf{MSD}}-\hat H_{\mathsf{MSD}}|$';
end

lblf = {};
lblf.fom = ' Full model';
lblf.lwn = sprintf(' Plain Loewner(r=%d)', r);
lblf.nlw = sprintf(' poly-Loewner(r=%d)', r);
lblf.caa = ' poly-AA';

figure
colororder(syscolors)
h1 = loglog(imag(omega_all),abs(reshape(H1(1,1,:),1,length(omega_all)))); hold on
h2 = loglog(imag(omega_all),abs(reshape(H2(1,1,:),1,length(omega_all))),'-.');
h3 = loglog(imag(omega_all),abs(reshape(H3(1,1,:),1,length(omega_all))),'--');
h4 = loglog(imag(freq),abs(Hfit), ':');
title(sprintf('%s-Example: Frequency response', problem));
legend([h1 h2 h3 h4], lblf.fom, lblf.lwn, lblf.nlw, lblf.caa, ... 
       'Location','northwest');
xlabel('Frequency');
ylabel(abstfname, "Interpreter", "latex");
saveas(gcf, ['figures/' problem '_freqresp'], 'epsc')
saveas(gcf, ['figures/' problem '_freqresp'], 'png')

% axis tight
% xt={'10^{-2}'; '10^0'; '10^2'; '10^4'; '10^6'} ; 
% set(gca,'xtick',[10^(-2) 10^(0) 10^2 10^4 10^6]); 
% set(gca,'xticklabel',xt);

figure
colororder(errcolors)
loglog(imag(omega_all),abs(reshape(H1(1,1,:),1,length(omega_all))-reshape(H2(1,1,:),1,length(omega_all)))...
./abs(reshape(H1(1,1,:),1,length(omega_all))),'-.'); hold on;
loglog(imag(omega_all),abs(reshape(H1(1,1,:),1,length(omega_all))-reshape(H3(1,1,:),1,length(omega_all)))...
./abs(reshape(H1(1,1,:),1,length(omega_all))),'--'); hold on;
loglog(imag(freq),abs(Horig-Hfit)./abs(Horig), ':');
title(sprintf('%s-Example: Relative approximation error', problem));
legend(lblf.lwn, lblf.nlw, lblf.caa,'Location','northeast');
xlabel('Frequency');
ylabel(relerrtfname, "Interpreter", "latex");
saveas(gcf, ['figures/' problem '_relerr'], 'epsc')
saveas(gcf, ['figures/' problem '_relerr'], 'png')

% axis tight
% % 
% xlim([10^(-2) 10^5]);
% % ylim([10^(-8) 10^0]);
% % 
% xt={'10^{-2}'; '10^0'; '10^2'; '10^4'; '10^6'} ; 
% set(gca,'xtick',[10^(-2) 10^(0) 10^2 10^4 10^6]); 
% set(gca,'xticklabel',xt);
% % 
% yt={'10^{-10}';'10^{-8}'; '10^{-6}'; '10^{-4}'; '10^{-2}'; '10^0'} ; 
% set(gca,'ytick',[10^(-10) 10^(-8) 10^(-6) 10^(-4) 10^(-2) 10^0]); 
% set(gca,'yticklabel',yt);
