#!/bin/bash
## Treeannotation: summarize the information from a sample of trees produced by BEAST onto a single “target” tree. (program details in https://beast.community/treeannotator)

workdir="/path/to/Example_Project/Divergence_example/treeannotator_files"
BEAST2_TreeAnnotator_dir="/path/to/beast/"  ## v2.5.2  
input_tree_file="/path/to/Example_Project/Divergence_example/beast_output_files/Divergence_example.trees"  ## output treefile generated by BEAST 2.
target_tree_file="/path/to/Example_target_tree.treefile"  ## specifies a user target tree (phylogenetic tree of curated 600PVs) to be annotated.
output_file="Divergence_annotation_example.txt"

cd $workdir
$BEAST2_TreeAnnotator_dir/treeannotator -burnin 10 \
    -target $target_tree_file \
    -lowMem \
    $input_tree_file \
    $output_file
