#!/bin/bash
## estimate rooted, time-measured phylogenetic tree using relaxed molecular clock models.

workdir="/path/to/Example_Project/Divergence_example"
BEAST_dir="/path/to/beast/"  ## v2.5.2
input_xml_file="/path/to/Example_Project/Divergence_example/input_xml_files/input_example.xml" ## input XML file generated by BEAUti (a graphical application for generating BEAST XML files).
state_file="/path/to/Example_Project/Divergence_example/beast_output_files/Divergence_example.states"  ## Specify the filename for storing/restoring the state.
prefix="Divergence_example"
threads="threads"
seed="seed"

cd $workdir
$BEAST_dir/beast -seed $seed \
 -beagle_SSE \
 -beagle_GPU \
 -beagle_double \
 -loglevel info \
 -prefix $prefix \
 -statefile $state_file \
 -threads $threads \
 $input_xml_file