#!/bin/bash
## generate linkage disequilibrium (LD) heatmap of cancer-prognosis related SNVs

date
workdir="/path/to/Example_Project/Genome_SNV/LDBlockShow_example"
scripts_dir="/path/to/scripts"
python_dir="/path/to/python" #v3.9.12
LDBlockShow_dir="/path/to/LDBlockShow" ##v1.40
output_dir="/path/to/output"
cd $workdir

disease="disease"
vcf="disease_SNV_vcf_file"  ##example_disease_snp_sort.vcf
clade="disease_clade_file"  ##example_clade.txt
gff="reference_genome_annotation"   ##example_ref_annotation.gff3
snps="./input/${disease}_snps.txt"
output="./input/${disease}.vcf"
output2="./input/${disease}_top200.vcf"


## step1: prepare the input vcf file for LDBlockShow
$python_dir/python3 -u $scripts_dir/12_prepare_LDBlockShow_input_vcf.py \
    -vcf $vcf \
    -clade $clade \
    -disease $disease \
    -snps $snps \
    -output $output \
    -output2 $output2 
    
## step2: generate linkage disequilibrium (LD) heatmap from VCF file
$LDBlockShow_dir/LDBlockShow \
    -InVCF $output2 \
    -InGFF $gff \
    -ShowGWASSpeSNP \
    -MAF 0.01 \
    -Miss 0.25 \
    -OutPut  $output_dir\
    -Region "the_length_of_reference_genome"\       ##HPV16:1:7906
    -OutPng \
    -SeleVar 2 \
    -BlockType 1

echo "Done!"
date









