#!/bin/bash
##predict the functional effects of genomic variants
date
workdir="/path/to/Example_Project/Genome_SNV/VEP_example"
vep_dir="/path/to/ensembl-vep" ##v109.3
cd $workdir

## step1: database setup
if [ ! -d ./database ];then mkdir ./database;fi
ref_genome="referenc_ref_genome_fasta"  ##example_ref_genome.fa
ref_gff="referenc_ref_genome_annotation"  #example_ref_annotation.gff3
prefix1="prefix1"

cd ./database
cat $ref_genome | bgzip -c > $prefix1.fa.gz
cat $ref_gff | sort -t $'\t' -k1,1 -k4,4n -k5,5n | bgzip -c > $prefix1.ref_gff.gz
tabix -p ref_gff $prefix1.ref_gff.gz
cd ../

## step2: predict the functional effects of genomic variants
prefix2="prefix2"
input_vcf="vcf_file"  ##produced_by_program_"07_02_run_snp_sort.sh"

output_prefix="${prefix2}.rm_repeat"

$vep_dir/vep -i $input_vcf \
    --ref_gff ./database/$prefix1.ref_gff.gz \
    --fasta ./database/$prefix1.fa.gz \
    -o $output_prefix.vep.vcf \
    --force_overwrite
date
echo ""
echo "VEP done!"







