#!/bin/bash
## remove a bootstrap value and reroot the phylogenetic tree to produce the figure with the ggtree.R

workdir="/path/to/Example_Project/Phylogenetic_tree_filter"
newick_utils_dir="/path/to/newick_utils" ##v1.6
cd $workdir
input_tree="phylogenetic_tree_file"  ##phylogenetic tree produced by IQ-TREE (v2.0.6) in program "06_run_cactus.sh".
output_tree="output.treefile"
output_reroot_tree="output_reroot.treefile"
flag=2 ## flag == 1 or flag == 2

if [ $flag -eq 1 ]
then
	## remove the first bootstrap value
	cat $input_tree | sed -E 's/\)[^\/]*\//\)/g' > $output_tree
else
	## remove the second bootstrap value
	cat $input_tree | sed 's/\/[^:]*:/:/g' > $output_tree
fi

$newick_utils_dir/nw_reroot $output_tree "the root of phylogenetic tree" > $output_reroot_tree
