#!/bin/bash
#the alignment of genome with MAFFT (v7.310)
#guide tree produced by IQ-TREE (v2.0.6)
workdir="/path/to/Example_Project/Genome_alignment/MAFFT_alignment_example"
genome_dir="/path/to//Example_Project/Genome_alignment/MAFFT_alignment_example/softmask_genome"
iqtree_dir="/path/to/IQ-TREE"
mafft_dir="/path/to/MAFFT"
clipkit_dir="/path/to/clipkit"
prefix="any prefix you like"
threads="Number of threads"
seed="any seed you like"
cd $workdir

##
cat `ls $genome_dir/*.softmask.fa` > $prefix.noref.softmask.fa ##Gather all sequences in one fasta file

## mafft
$mafft_dir/mafft --auto --thread $threads --preservecase $prefix.noref.softmask.fa > $prefix.mafft.fa ##genome alignment with MAFFT

## clipkit
$clipkit_dir/clipkit $prefix.mafft.fa -m gappy -g 0.9 -o $prefix.mafft.clip.fa ##alignment trimming by clipkit (v1.3.0)

## iqtree v2.0.6
$iqtree_dir/iqtree2 -s ./$prefix.mafft.clip.fa \
        --seed $seed \
        -m MFP \
        -B 1000 --bnni \
        -alrt 1000 \
        -T $threads \
        --prefix $prefix.clip.iqtree \
        --safe


