#!/bin/bash
#mask out highly repetitive and low complexity DNA sequences within a genome using the sequence of the genome itself
#WindowMasker (v1.0.0)

genome_dir="/path/to/Example_Project/Genome_softmask/raw_genome"
softmask_dir="/path/to/Example_Project/Genome_softmask/softmask_genome"
windowmasker_dir="/path/to/windowmasker"
cd $softmask_dir

for strain in `cut -f 1 strain_name_file`
do

$windowmasker_dir/windowmasker \
    -checkdup true \
    -mk_counts \
    -in $genome_dir/$strain.fa \
    -out $strain.masking_library.ustat \
    -mem 65000

$windowmasker_dir/windowmasker \
    -ustat $strain.masking_library.ustat \
    -in $genome_dir/$strain.fa \
    -out $strain.softmask.fa \
    -outfmt fasta \
    -dust true

done
