#!/bin/bash
#download_gff3_files_from_ncbi
work_dir="/path/to/Example_Project/Retrieve_raw_annotation/download_example"
parallel_dir="/path/to/ParaFly"
cd $work_dir

assembly_accession_id_file="Accession_id_file"
threads="Number of threads"

cat $assembly_accession_id_file | while read line
do
IFS=$'\t' read sample_name acc_id <<< "$line"
echo "wget -O $sample_name.gff3 \"https://www.ncbi.nlm.nih.gov/sviewer/viewer.cgi?db=nuccore&report=gff3&id=${acc_id}\""
done > run_retrieve_gff3_from_ncbi.jobs

$parallel_dir -j $threads < run_retrieve_gff3_from_ncbi.jobs
echo "Done!"
