import csv
import random

class DatasetMapper:
    def read(self, file_path, offset = 0, rows = -1, exclude = None):
        x = []
        y = []

        with open(file_path) as csv_file:
            csv_reader = csv.reader(csv_file, delimiter = ',')
            line_count = 0
            for row in csv_reader:
                if line_count - offset > rows and rows >= 0:
                    break
                if line_count > offset:
                    y.append(row[0])
                    x_row = row[1:]
                    if exclude != None:
                        assert 0 < exclude and exclude <= len(x_row)

                        del x_row[exclude - 1]
                    for i in range(len(x_row)):
                        if(x_row[i] == 'True'):
                            x_row[i] = 1
                        if(x_row[i] == 'False'):
                            x_row[i] = 0
                    x.append(x_row)
                line_count += 1
        return x, y

    def shuffle(self, x, y):
        temp = list(zip(x, y))
        random.shuffle(temp)
        res1, res2 = zip(*temp)
        res1, res2 = list(res1), list(res2)
        return res1, res2

