# coding: utf-8

import sys
import time
import json
from forwardprocess import ForwardVisitor
from backwardprocess import BackwardVisitor
from log import logger
import logging
from invoke_local import get_annotation
from inference import inference

from ConstructKB.get_pre_sta import get_knowledge
def add_annotation(name,forwardprocessor):
    annotations = get_annotation(name)
    for item in forwardprocessor.funcs_manager.names:
        if item not in annotations[name]:
            annotations[name][item] = {'API_name':item,'loc_name':item}
    for item in forwardprocessor.classes_manager.names:
        if item not in annotations[name]:
            annotations[name][item] = {'API_name':item,'loc_name':item}
    with open(f'pre_knowledge/{name}_pre_annotations.json','w') as f:
        json.dump(annotations,f,indent=4)

if __name__ == '__main__':


    pro_name = sys.argv[1]
    pro_path = sys.argv[2]
    if len(sys.argv) > 3:
        depconfig_path = sys.argv[3]
    
    # pro_name = 'flask'
    # pro_path = 'repo/flask/src/flask'
    # depconfig_path = 'repo/flask'

    get_knowledge(pro_name,pro_path,depconfig_path)
    # get_knowledge('flask' ,'repo/flask/src/flask','repo/flask') #

    forwardprocessor = ForwardVisitor(pro_path,pro_name)
    add_annotation(pro_name,forwardprocessor)
    backprocessor = BackwardVisitor(pro_path,forwardprocessor.global_values,forwardprocessor.funcs_manager,pro_name,forwardprocessor.classes_manager)
    annotations = get_annotation(pro_name)
    inference(pro_name,backprocessor,annotations,f'result/{pro_name}.json')
    