import ast
from .class_visitor import ClassVisitor
from .fun_def_visitor import FunDefVisitor

class function_node(object):
    def __init__(self,name,args,args_default,filepath='*',lineno='*',namespace='*'):
        self.name = name
        self.args = args
        self.args_default = args_default
        self.filepath = filepath
        self.lineno = lineno
        self.namespace = namespace

def get_keywords(node,filepath='*'):
    args = node.args
    arg_names = []
    defaults = args.defaults
    for arg in args.args:
        arg_names += [arg.arg]
    # tmp = function_node(node.name,arg_names,len(defaults),filepath,node.lineno,'.'.join(scope)) 

    return (arg_names, len(defaults),node.lineno)


def get_node_name(ast_node):
    if isinstance(ast_node,ast.Attribute):
        full_attrName = [ast_node.attr]
        now_attrName = ast_node.value
        while isinstance(now_attrName,ast.Attribute):
            full_attrName.append(now_attrName.attr)
            now_attrName = now_attrName.value
        if isinstance(now_attrName,ast.Name):
            full_attrName.append(now_attrName.id)
        full_attrName = reversed(full_attrName)
        return '.'.join(full_attrName)
    
    if isinstance(ast_node,ast.Name):
        return ast_node.id

    if isinstance(ast_node,ast.Subscript):
        if isinstance(ast_node.value,ast.Name):
            return ast_node.value.id

    return None

class SourceVisitor(ast.NodeVisitor):
    def __init__(self):
        self.result = {}
        self.scope = []
    def visit_FunctionDef(self, node):
        # self.scope.append('Function#{}'.format(node.name))
        kw_names = get_keywords(node)
        self.result[node.name] = kw_names
        # self.scope.pop()
        return node
        
    def visit_AsyncFunctionDef(self, node):
        self.visit_FunctionDef(node)

    def visit_ClassDef(self, node):
        visitor = ClassVisitor()
        visitor.visit(node)
        # if node.name == 'HttpError':
        #     print('why')
        visitor.result['self_init'] = ('*','*',node.lineno)  #初始化要定义一个，即使没有method
        # inherited_classes = []  #获取继承关系]
        # for cls_name in node.bases:
        #     parsed_name =  get_node_name(cls_name)
        #     if parsed_name:
        #         inherited_classes.append(parsed_name)
        #     else:
        #         print('point')
        # visitor.result['inherit_from'] = ('*','*',inherited_classes)
        self.result[node.name] = visitor.result
        return node
