% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biocol.R
\name{read_calc_biocol}
\alias{read_calc_biocol}
\title{Calculate BioCol based on a PNV run and LU run of LPJmL}
\usage{
read_calc_biocol(
  files_scenario,
  files_baseline,
  files_reference = NULL,
  time_span_scenario,
  time_span_baseline = NULL,
  time_span_reference = NULL,
  gridbased = TRUE,
  read_saved_data = FALSE,
  save_data = FALSE,
  data_file = NULL,
  include_fire = FALSE,
  external_fire = FALSE,
  external_wood_harvest = FALSE,
  grass_scaling = FALSE,
  npp_threshold = 20,
  epsilon = 0.001,
  grass_harvest_file = "grazing_data.RData",
  external_fire_file = "human_ignition_fraction.RData",
  external_wood_harvest_file = "wood_harvest_biomass_sum_1500-2014_67420.RData"
)
}
\arguments{
\item{files_scenario}{list with variable names and corresponding file paths
(character string) of the scenario LPJmL run. All needed files are
provided in XXX. E.g.: list(npp = "/temp/npp.bin.json")}

\item{files_baseline}{list with variable names and corresponding file paths
(character string) of the baseline LPJmL run. All needed files are
provided in XXX. E.g.: list(npp = "/temp/npp.bin.json"). If not
needed for the applied method, set to NULL.}

\item{files_reference}{list with npp file path (character string) of the
reference LPJmL run (usually Holocene/preindustrial).
E.g.: list(npp = "/temp/npp.bin.json"). If NULL uses baseline npp.}

\item{time_span_scenario}{time span to be used for the scenario run, defined
as a character vector, e.g. `as.character(1982:2011)` (required)}

\item{time_span_baseline}{time span to be used for the baseline run, defined
as a character vector, e.g. `as.character(1901:1930)`. Can differ in offset
and length from `time_span_scenario`! If `NULL` value of `time_span_scenario`
is used}

\item{time_span_reference}{time span to read reference npp from, using
index years 10:39 from potential npp input if set to NULL (default: NULL)}

\item{gridbased}{logical are pft outputs gridbased or pft-based?}

\item{read_saved_data}{flag whether to read previously saved data
instead of reading it in from output files (default FALSE)}

\item{save_data}{whether to save input data to file (default FALSE)}

\item{data_file}{file to save/read input data to/from (default NULL)}

\item{include_fire}{boolean include firec in calculation of BioCol?
(default TRUE)}

\item{external_fire}{instead of reading in firec for fire emissions, read in
       this external firec file from a separate spitfire run with disabled
       lighning. this will then include only human induced fires
(default FALSE)}

\item{external_wood_harvest}{include external wood harvest from LUH2_v2h
(default FALSE)}

\item{grass_scaling}{whether to scale pasture harvest according to
data given via grass_harvest_file (default FALSE)}

\item{npp_threshold}{lower threshold for npp (to mask out non-lu areas
according to Haberl et al. 2007). Below BioCol will be set to 0.
(default: 20 gC/m2)}

\item{epsilon}{minimum value for npp, below which it will be set to 0}

\item{grass_harvest_file}{file containing grazing data to rescale the
grassland harvests according to Herrero et al. 2013. File contains:
grazing_data list object with $name and $id of 29 world regions, and
$Herrero_2000_kgDM_by_region containing for each of these regions and
mapping_lpj67420_to_grazing_regions array with a mapping between 67420
LPJmL cells and the 29 regions}

\item{external_fire_file}{path to external file with human induced fire
fraction c(cell,month,year) since 1500}

\item{external_wood_harvest_file}{path to R-file containing processed
timeline of maps for LUH2_v2h woodharvest}
}
\value{
list data object containing BioCol and components as arrays: biocol,
        biocol_overtime, biocol_overtime_piref, biocol_frac, npp_potential,
        biocol_overtime_abs_frac_piref, biocol_frac_piref, npp_act_overtime,
        npp_pot_overtime, npp_eco_overtime, npp_ref, harvest_cft_overtime,
        npp_luc_overtime, rharvest_cft_overtime, fire_overtime,
        timber_harvest_overtime, harvest_cft, rharvest_cft,
        wood_harvest_overtime, biocol_harvest, biocol_luc
}
\description{
Function to calculate BioCol based on a PNV run and LU run of LPJmL
}
