% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_global.R
\name{plot_global_to_screen}
\alias{plot_global_to_screen}
\title{Plot global LPJmL array}
\usage{
plot_global_to_screen(
  data,
  title = "",
  pow2max = NULL,
  pow2min = NULL,
  min = NULL,
  max = NULL,
  col_pos = "GnBu",
  type = "exp",
  col_neg = "YlOrRd",
  legendtitle = "",
  leg_yes = TRUE,
  only_pos = FALSE,
  n_legend_ticks = 20,
  min_0 = 0.01
)
}
\arguments{
\item{data}{array with data to plot in LPJmL specific array c(67420)}

\item{title}{character string title for plot}

\item{pow2max}{for exponential legend: upper (positive) end of data range to
plot (2^pow2max)}

\item{pow2min}{for exponential legend: smallest positive number to be
distinguished from 0 (2^-pow2min)}

\item{min}{for linear legend: lower end of data range to plot (0 is placed
symmetrically between min and max, if onlypos = FALSE)}

\item{max}{for linear legend: upper end of data range to plot (0 is placed
symmetrically between min and max, if onlypos = FALSE)}

\item{col_pos}{color palette for the positives}

\item{type}{string indicating whether to plot exponential (exp) or
linear (lin) legend (default: exp)}

\item{col_neg}{color palette for the negatives}

\item{legendtitle}{character string legend title}

\item{leg_yes}{boolean whether to show legend (default: TRUE)}

\item{only_pos}{boolean to show only positive half of legend (default: FALSE)}

\item{file}{character string for location/file to save plot to}

\item{eps}{boolean whether to write eps file instead of PNG (default: FALSE)}
}
\value{
None
}
\description{
Plot of a global LPJmL array inside RStudio
   Data is plotted in range: c(-2^pow2max,-2^-pow2min,0,2^-pow2min,2^pow2max)
   where the positive values are colored green to blue,
   0-range is white,
   and the negative ones red to yellow
}
\examples{
\dontrun{
plot_global_to_screen(
  data = irrigation2006,
  title = paste("irrigation amount 2006 in mm/yr", sep = ""),
  pow2max = 15,
  pow2min = 0,
  "legendtitle",
  leg_yes = TRUE
)
}

}
