% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecorisk.R
\name{plot_ecorisk_map}
\alias{plot_ecorisk_map}
\title{Plot EcoRisk map to file}
\usage{
plot_ecorisk_map(
  data,
  file,
  focus_biome = NULL,
  biome_classes = NULL,
  title = "",
  legendtitle = "",
  eps = FALSE,
  title_size = 1,
  leg_yes = TRUE,
  palette = NULL
)
}
\arguments{
\item{data}{folder of reference run}

\item{file}{to write into}

\item{focus_biome}{highlight the biome with this id and desaturate all other
(default NULL -- no highlight)}

\item{biome_classes}{to mask the focus_biome from}

\item{title}{character string title for plot, default empty}

\item{legendtitle}{character string legend title}

\item{eps}{write as eps or png}

\item{leg_yes}{logical. whether to plot legend or not. defaults to TRUE}

\item{palette}{color palette to plot EcoRisk with, defaults to the Ostberg
color scheme white-blue-yellow-red}

\item{leg_scale}{scaling factor for legend. defaults to 1}
}
\value{
None
}
\description{
Function to plot a global map of EcoRisk values [0-1] per grid cell to file
}
