% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecorisk.R, R/plot_biomes.R
\name{plot_biomes}
\alias{plot_biomes}
\title{Plot biomes to file}
\usage{
plot_biomes(
  biome_data,
  file_name = NULL,
  display_area = FALSE,
  cellarea = NULL,
  order_legend = c(1, 2, 9, 10, 11, 3, 4, 5, 12, 13, 14, 6, 7, 8, 15, 16, 17, 18, 19),
  bg_col = "white"
)

plot_biomes(
  biome_data,
  file_name = NULL,
  display_area = FALSE,
  cellarea = NULL,
  order_legend = c(1, 2, 9, 10, 11, 3, 4, 5, 12, 13, 14, 6, 7, 8, 15, 16, 17, 18, 19),
  bg_col = "white"
)
}
\arguments{
\item{biome_data}{output (list) from classify_biomes()}

\item{file_name}{directory for saving the plot (character string)}

\item{display_area}{boolean, adding occupied area per biome (default FALSE)}

\item{order_legend}{in which order the biomes should be displayed
default: c(1,2,9,10,11,3,4,5,12,13,14,6,7,8,15,16,17,18,19)}

\item{bg_col}{character, specify background possible (\code{NA} for transparent)}

\item{biome_ids}{biome id as given by classify_biomes}

\item{biome_name_length}{length of biome names in legend: 1 - abbreviation,
2 - short name, 3 - full biome name}

\item{file}{to write into}

\item{title}{character string title for plot, default empty}

\item{title_size}{size of title in cex units (defaukt: 2)}

\item{leg_yes}{whether to plot legend (default: True)}

\item{leg_scale}{size of legend in cex units (default 0.5)}

\item{eps}{write as eps, replacing png in filename (default: True)}

\item{to_robinson}{logical to define if robinson projection should be used
for plotting}
}
\value{
None
}
\description{
Function to plot biome classification to file

Plots a map with the biome distribution as derived from a lpjml run based
on the "classify_biomes" function
}
\examples{
\dontrun{
 plot_biomes(biome_data = biomes,
             file_name ="/p/projects/open/Johanna/R/biomes.pfd")
}

}
