% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biocol.R
\name{plot_biocol_ts}
\alias{plot_biocol_ts}
\title{Plot absolute BioCol, overtime, maps, and npp into given folder}
\usage{
plot_biocol_ts(
  biocol_data,
  file,
  first_year,
  plot_years,
  highlight_years = 2000,
  details = FALSE,
  min_val = 0,
  max_val = 100,
  max_val_right = 0.45,
  legendpos = "topleft",
  ext = FALSE,
  eps = FALSE,
  ref = "pi"
)
}
\arguments{
\item{biocol_data}{biocol data list object (returned from calc_biocol)
containing biocol, npp_eco_overtime, npp_act_overtime, npp_pot_overtime,
npp_bioenergy_overtime, biocol_overtime, npp_harv_overtime,
biocol_overtime_perc_piref, biocol_perc, biocol_perc_piref, npp
all in GtC}

\item{file}{character string for location/file to save plot to}

\item{first_year}{first year of biocol object}

\item{plot_years}{range of years to plot over time}

\item{highlight_years}{year(s) that should be highlighted in overtime plot
(default: 2000)}

\item{details}{show all harvest components or not}

\item{min_val}{y-axis minimum value for plot over time (default: 0)}

\item{max_val}{y-axis maximum value for plot over time (default: 100)}

\item{legendpos}{position of legend (default: "topleft")}

\item{eps}{write plots as eps, instead of png (default = FALSE)}

\item{ref}{reference period for biocol ("pi" or "act"), to either use
biocol_data$biocol_overtime_perc_piref or biocol_data$biocol_overtime}
}
\value{
none
}
\description{
Plot to file a comparison over time of global sums of BioCol, NPPpot, NPPeco,
and NPPact, with legend similar to Krausmann et al. 2013
}
