% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biocol.R
\name{plot_biocol}
\alias{plot_biocol}
\title{Plot absolute BioCol, overtime, maps, and npp into given folder}
\usage{
plot_biocol(
  biocol_data,
  path_write,
  plotyears,
  min_val,
  max_val,
  legendpos,
  details = FALSE,
  start_year,
  mapyear,
  mapyear_buffer = 5,
  highlightyear,
  eps = FALSE
)
}
\arguments{
\item{biocol_data}{biocol data list object (returned from calc_biocol)
containing biocol, npp_eco_overtime, npp_act_overtime, npp_pot_overtime,
npp_bioenergy_overtime, biocol_overtime, npp_harv_overtime,
biocol_overtime_perc_piref, biocol_perc, biocol_perc_piref, npp all in GtC}

\item{path_write}{folder to write into}

\item{plotyears}{range of years to plot over time}

\item{min_val}{y-axis minimum value for plot over time}

\item{max_val}{y-axis maximum value for plot over time}

\item{legendpos}{position of legend}

\item{details}{show all harvest components or not}

\item{start_year}{first year of biocol_data object}

\item{mapyear}{year to plot biocol map for}

\item{mapyear_buffer}{+- years around mapyear to average biocol
(make sure these years exist in biocol_data)}

\item{highlightyear}{year(s) that should be highlighted in overtime plot}

\item{eps}{write plots as eps, instead of png (default = FALSE)}
}
\value{
none
}
\description{
Wrapper function to plot absolute biocol, overtime, maps, and npp into given
folder
}
