% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecorisk.R
\name{ecorisk_wrapper}
\alias{ecorisk_wrapper}
\title{Wrapper for calculating the ecosystem change metric EcoRisk}
\usage{
ecorisk_wrapper(
  path_ref,
  path_scen,
  read_saved_data = FALSE,
  save_data = NULL,
  save_ecorisk = NULL,
  nitrogen = TRUE,
  weighting = "equal",
  varnames = NULL,
  time_span_reference,
  time_span_scenario,
  dimensions_only_local = FALSE,
  overtime = FALSE,
  window = 30,
  debug = FALSE
)
}
\arguments{
\item{path_ref}{folder of reference run}

\item{path_scen}{folder of scenario run}

\item{read_saved_data}{whether to read in previously saved data
(default: FALSE)}

\item{save_data}{file to save read in data to (default NULL)}

\item{save_ecorisk}{file to save EcoRisk data to (default NULL)}

\item{nitrogen}{include nitrogen outputs for pools and fluxes into EcoRisk
calculation (default FALSE)}

\item{weighting}{apply "old" (Ostberg-like), "new", or "equal" weighting of
vegetation_structure_change weights (default "equal")}

\item{varnames}{data.frame with names of output files (outname) and time res.
(timestep) -- can be specified to account for variable file names
(default NULL -- standard names as below)}

\item{time_span_reference}{vector of years to use as scenario period}

\item{time_span_scenario}{vector of years to use as scenario period}

\item{dimensions_only_local}{flag whether to use only local change component
for water/carbon/nitrogen fluxes and pools, or use an average of
local change, global change and ecosystem balance (default FALSE)}

\item{overtime}{logical: calculate ecorisk as time-series? (default: FALSE)}

\item{window}{integer, number of years for window length (default: 30)}

\item{debug}{write out all nitrogen state variables (default FALSE)}
}
\value{
list data object containing arrays of ecorisk_total,
        vegetation_structure_change, local_change, global_importance,
        ecosystem_balance, carbon_stocks, carbon_fluxes, water_fluxes 
        (+ nitrogen_stocks and nitrogen_fluxes)
}
\description{
Function to read in data for ecorisk, and call the calculation function once,
if overtime is FALSE, or for each timeslice of length window years, if
overtime is TRUE
}
