% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecorisk.R
\name{ecorisk_cross_table}
\alias{ecorisk_cross_table}
\title{Create modified EcoRisk data for crosstable}
\usage{
ecorisk_cross_table(
  data_file_in,
  data_file_out,
  biome_classes_in,
  pick_cells = NULL,
  baseline_ref = FALSE
)
}
\arguments{
\item{data_file_in}{path to input data}

\item{data_file_out}{path to save modified data to}

\item{biome_classes_in}{biome classes object as returned from classify_biomes}

\item{pick_cells}{pick one specific cell as representative for the biome
instead of computing the average state}

\item{baseline_ref}{logical, use reference state as baseline? 
default is F - use scenario state}
}
\description{
Function to create a modified EcoRisk data file where for each biome
the average scenario cell is compared to the average scenario cell of all
other biomes. This can then be used to compute a crosstable with the average
difference between each of them as in the SI of Ostberg et al. 2013
(Critical impacts of global warming on land ecosystems)
}
