% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecorisk.R
\name{disaggregate_into_biomes}
\alias{disaggregate_into_biomes}
\title{Averages EcoRisk values across regions}
\usage{
disaggregate_into_biomes(
  data,
  biome_class,
  type = "quantile",
  classes = "4biomes"
)
}
\arguments{
\item{data}{List object, of which every item should be disaggregated}

\item{biome_class}{biome class list object as returned by classify_biomes}

\item{type}{string controlling whether to return  minimum, mean, maximum
("minmeanmax") or Q10,Q50,Q90 ("quantile") - default: "quantile"}

\item{classes}{string for into how many regions should be disaggregated
"4biomes" (tropics/temperate/boreal/arctic) or "allbiomes"}
}
\description{
Returns the average value across either 4 regions or all (19) biomes for
EcoRisk and each of the subcomponents for each
}
\examples{
\dontrun{
disaggregate_into_biomes(
  ecorisk = ecorisk,
  biome_class = biome_classes,
  type = "quantile", classes = "4biomes"
)
}
}
