% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classify_biomes.R
\name{classify_biomes}
\alias{classify_biomes}
\title{Classify biomes}
\usage{
classify_biomes(
  path_reference = NULL,
  files_reference = NULL,
  time_span_reference,
  savanna_proxy = list(pft_lai = 6),
  montane_arctic_proxy = list(elevation = 1000),
  tree_cover_thresholds = list(),
  avg_nyear_args = list(),
  input_files = list(),
  diff_output_files = list()
)
}
\arguments{
\item{path_reference}{path to the reference LPJmL run. If not provided,
the path is extracted from the file paths provided in files_reference.}

\item{files_reference}{list with variable names and corresponding file paths
(character string) of the reference LPJmL run. All needed files are
provided as key value pairs, e.g.:
list(leaching = "/temp/leaching.bin.json"). If not needed for the
applied method, set to NULL.}

\item{time_span_reference}{time span to be used for the scenario run, defined
as an character string, e.g. `as.character(1901:1930)`.}

\item{savanna_proxy}{`list` with either pft_lai or vegc as
key and value in m2/m2 for pft_lai (default = 6) and gC/m2 for
vegc (default would be 7500), Set to `NULL` if no proxy should be
used.}

\item{montane_arctic_proxy}{`list` with either "elevation" or "latitude" as
name/key and value in m for elevation (default 1000) and degree for
latitude (default would be 55), Set to `NULL` if no proxy is used.}

\item{tree_cover_thresholds}{list with minimum tree cover thresholds for
definition of forest, woodland, savanna and grassland. Only changes to
the default have to be included in the list, for the rest the default
is used.
Default values, based on the IGBP land cover classification system:
"boreal forest" = 0.6
"temperate forest" = 0.6
"temperate woodland" = 0.3
"temperate savanna" = 0.1
"tropical forest" = 0.6
"tropical woodland" = 0.3
"tropical savanna" = 0.1
In the boreal zone, there is no woodland, everything below the
boreal forest threshold will be classified as boreal tundra.}

\item{avg_nyear_args}{list of arguments to be passed to
\link[biospheremetrics]{average_nyear_window} (see for more info). To be used for # nolint
time series analysis}
}
\value{
list object containing biome_id (main biome per grid cell [dim=c(ncells)]), # nolint
and list of respective biome_names[dim=c(nbiomes)]
}
\description{
Classify biomes based on foliage protected cover (FPC) and temperature
LPJmL output plus either vegetation carbon or pft_lai depending on
the savanna_proxy option and elevation if montane_arctic_proxy requires this
}
\examples{
\dontrun{
classify_biomes(
  path_data = "/p/projects/open/Fabian/runs/Gamma/output/historic_gamma"
  timespan = c(1982:2011))
}

}
