% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecorisk.R
\name{calculate_within_biome_diffs}
\alias{calculate_within_biome_diffs}
\title{Calculate ecorisk with each biomes average cell}
\usage{
calculate_within_biome_diffs(
  biome_classes,
  data_file_base,
  intra_biome_distrib_file,
  create = FALSE,
  nitrogen = TRUE,
  res = 0.05,
  plotting = FALSE,
  plot_folder,
  time_span_reference,
  vars_ecorisk,
  ecorisk_components = 13
)
}
\arguments{
\item{biome_classes}{biome classes object as returned by classify biomes,
calculated for data_file_base}

\item{data_file_base}{base EcoRisk to compute differences with (only ref is
relevant)}

\item{intra_biome_distrib_file}{file to additionally write results to}

\item{create}{create new modified files, or read already existing ones?}

\item{res}{how finegrained the distribution should be (resolution)}

\item{plotting}{whether plots for each biome should be created}

\item{plot_folder}{folder to plot into}

\item{time_span_reference}{suitable 30 year reference period (e.g.
c(1901,1930), c(1550,1579))}
}
\value{
data object with distibution - dim: c(biomes,ecorisk_variables,bins)
}
\description{
Function to calculate ecorisk with each biomes average cell
as a measure of internal variability
}
