% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecorisk.R
\name{calc_ecorisk}
\alias{calc_ecorisk}
\title{Calculate the ecosystem change metric EcoRisk between 2 sets of states}
\usage{
calc_ecorisk(
  fpc_ref,
  fpc_scen,
  bft_ref,
  bft_scen,
  cft_ref,
  cft_scen,
  state_ref,
  state_scen,
  weighting = "equal",
  lat,
  lon,
  cell_area,
  dimensions_only_local = FALSE,
  nitrogen = TRUE
)
}
\arguments{
\item{fpc_ref}{reference run data for fpc}

\item{fpc_scen}{scenario run data for fpc}

\item{bft_ref}{reference run data for fpc_bft}

\item{bft_scen}{scenario run data for fpc_bft}

\item{cft_ref}{reference run data for cftfrac}

\item{cft_scen}{scenario run data for cftfrac}

\item{state_ref}{reference run data for state variables}

\item{state_scen}{scenario run data for state variables}

\item{weighting}{apply "old" (Ostberg-like), "new", or "equal" weighting of
vegetation_structure_change weights (default "equal")}

\item{lat}{latitude array}

\item{lon}{longitude array}

\item{cell_area}{cellarea array}

\item{dimensions_only_local}{flag whether to use only local change component
for water/carbon/nitrogen fluxes and pools, or use an average of
local change, global change and ecosystem balance (default FALSE)}

\item{nitrogen}{include nitrogen outputs (default: TRUE)}
}
\value{
list data object containing arrays of ecorisk_total,
        vegetation_structure_change, local_change, global_importance,
        ecosystem_balance, carbon_stocks, carbon_fluxes, water_fluxes
        (+ nitrogen_stocks and nitrogen_fluxes)
}
\description{
Function to calculate the ecosystem change metric EcoRisk, based on
gamma/vegetation_structure_change
work from Sykes (1999), Heyder (2011), and Ostberg (2015,2018).
This is a reformulated version in R, not producing 100% similar values
than the C/bash version from Ostberg et al. 2018, but similar the methodology
}
