% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecorisk.R
\name{calc_delta_v}
\alias{calc_delta_v}
\title{Calculates changes in vegetation structure (vegetation_structure_change)}
\usage{
calc_delta_v(
  fpc_ref,
  fpc_scen,
  bft_ref,
  bft_scen,
  cft_ref,
  cft_scen,
  weighting = "equal"
)
}
\arguments{
\item{fpc_ref}{reference fpc array (dim: [ncells,npfts+1])}

\item{fpc_scen}{scenario fpc array (dim: [ncells,npfts+1])}

\item{bft_ref}{reference bft array (dim: [ncells,nbfts])}

\item{bft_scen}{scenario bft array (dim: [ncells,nbfts])}

\item{cft_ref}{reference cft array (dim: [ncells,ncfts])}

\item{cft_scen}{scenario cft array (dim: [ncells,ncfts])}

\item{weighting}{apply "old" (Ostberg-like), "new", or "equal" weighting of
vegetation_structure_change weights (default "equal")}
}
\value{
vegetation_structure_change array of size ncells with the
        vegetation_structure_change value [0,1] for each cell
}
\description{
Utility function to calculate changes in vegetation structure
(vegetation_structure_change) for calculation of EcoRisk
}
\examples{
\dontrun{
vegetation_structure_change <- calc_delta_v(
  fpc_ref = fpc_ref_mean,
  fpc_scen = apply(fpc_scen, c(1, 2), mean),
  bft_ref = bft_ref_mean,
  bft_scen = apply(bft_scen, c(1, 2), mean),
  cft_ref = cft_ref_mean,
  cft_scen = apply(cft_scen, c(1, 2), mean),
  weighting = "equal"
)
}
}
