clear all
clc
syms qp53p21 Lambda_p53p21 eRp21 Temp ep21pai  qRp21 Lambda_Rp21  qp53bax Lambda_p53bax  eRbax qRbax Lambda_Rbax epaibax qp53pai Lambda_p53pai eRpai qRpai Lambda_Rpai qp53p48 Lambda_p53p48  eRp48 qRp48 Lambda_Rp48

% fileID1=fopen('NEWProDNA_1_epd_6kT_Fraction.out','w');
% Simulation parameters
lseg=18;  %length of segment
nseg=10;
Lx = nseg*lseg;   Ly=1;          % Number of sites on one side of the lattice
latticed=ones(1,Lx);
occd=latticed';
nSites = Lx*Ly;     % Total number of sites
Temp = 0.53;        % Temperature
nSteps=25000;      % Number of MC sweeps
KdA_p21=4.9;KdA_bax=100;
KdA_pai=9.2;KdA_p48=21;
KdR_p21=20;KdR_bax=20;KdR_pai=20;KdR_p48=20;
eAR_p21=-3*Temp;eAR_p48=-3*Temp;eAR_Bax=-3*Temp;eAR_PAI=-3*Temp;
activityR=10^-4;
Lambda_Rp21=activityR;Lambda_Rp48=activityR;Lambda_Rpai=activityR;Lambda_Rbax=activityR;
p=[];f_p21=[];f_p48=[];f_PAI=[];f_Bax=[];


eA_p21=-Temp*log(1/KdA_p21);eR_p21=-Temp*log(1/KdR_p21);
qp53p21=exp(-eA_p21/Temp);qRp21=exp(-eR_p21/Temp);
eA_bax=-Temp*log(1/KdA_bax);eR_bax=-Temp*log(1/KdR_p48);
qp53bax=exp(-eA_bax/Temp);qRbax=exp(-eR_bax/Temp);
eA_p48=-Temp*log(1/KdA_p48);eR_p48=-Temp*log(1/KdR_p48);
qp53p48=exp(-eA_p48/Temp);qRp48=exp(-eR_p48/Temp);
eA_pai=-Temp*log(1/KdA_pai);eR_pai=-Temp*log(1/KdR_pai);
qp53pai=exp(-eA_pai/Temp);qRpai=exp(-eR_pai/Temp);

eRp21=-3*Temp;wRp21=exp(-eRp21/Temp);
eRbax=-3.01*Temp;%pai is present in bulk which is activating bax
wRbax=exp(-eRbax/Temp);
eRpai=-3.5*Temp;wRpai=exp(-eRpai/Temp);

ep21pai=-3*Temp;
epaibax=-3*Temp;
ep21bax=3*Temp;
ep21p48=3*Temp;
eRp48=-2.5*Temp;wRp48=exp(-eRp48/Temp);
q=0;
for activityp53=10.^(-3:0.1:6)
    q=q+1;
    P53(1,q)=activityp53;
    
    Lambda_p53p21=activityp53;Lambda_p53bax=activityp53;Lambda_p53pai=activityp53;Lambda_p53p48=activityp53;
    
            %% NETWORK MATRIX WITH STATISTICAL WEIGHTS
        M_stat=[qp53p21*Lambda_p53p21   exp(-eRp21/Temp)         0               0                        0                   0                  0                   0;
                        0               qRp21*Lambda_Rp21        0             exp(-ep21bax/Temp)         0         exp(-ep21pai/Temp)           0            exp(-ep21p48/Temp);
                        0                    0          qp53bax*Lambda_p53bax  exp(-eRbax/Temp)           0                   0                  0                   0;
                        0                    0                   0            qRbax*Lambda_Rbax           0          exp(-epaibax/Temp)          0                   0;
                        0                    0                   0               0                qp53pai*Lambda_p53pai  exp(-eRpai/Temp)        0                   0;
                        0                    0                   0               0                        0            qRpai*Lambda_Rpai         0                   0;
                        0                    0                   0               0                        0                   0          qp53p48*Lambda_p53p48   exp(-eRp48/Temp);
                        0                    0                   0               0                        0                   0                  0              qRp48*Lambda_Rp48 ];
    
    %% Generalised Theoretical Procedure
    nodes=8;
    A=[dec2bin(0:2^nodes-1)' - '0']'; %% A Stores Total Number of microstates
    %% Filter or Restrictions
%     j=0;B=[];
%     for i=1:size(A,1)
%         if sum(A(i,2)+A(i,4))~=2 %%REPRESSOR
%             if sum(A(i,2)+A(i,8))~=2
%                 if sum(A(i,2)+A(i,3))~=2 %p53
%                     if sum(A(i,2)+A(i,7))~=2 %p53
%                         j=j+1;
                        B=A;%% B Contains the allowed microstates
%                     end
%                 end
%             end
%         end
%     end
    
    %% Convert information of adjacency matrix into dynamic matrix
    A_Dynamic=zeros(nodes,nodes);
    for j=1:size(B,1)
        M_num_p21=zeros(nodes,nodes);
        M_num_bax=zeros(nodes,nodes);
        M_num_pai=zeros(nodes,nodes);
        M_num_p48=zeros(nodes,nodes);
        for j1=1:nodes
            for j2=1:nodes
                if j2==j1
                    A_Dynamic(j1,j2)=B(j,j1);
                elseif j2>j1
                    A_Dynamic(1,2)=B(j,1)*B(j,2); A_Dynamic(3,4)=B(j,3)*B(j,4);
                    A_Dynamic(5,6)=B(j,5)*B(j,6); A_Dynamic(7,8)=B(j,7)*B(j,8);
                    A_Dynamic(2,8)=B(j,2)*B(j,8);A_Dynamic(2,4)=B(j,2)*B(j,4);%%REPRESSOR 
                    A_Dynamic(2,6)=B(j,2)*B(j,6);A_Dynamic(4,6)=B(j,4)*B(j,6);%%ACTIVATOR
                end
            end
        end
        if B(j,2)>0
            M_num_p21=A_Dynamic;%% If RNAP is present
        end
        if B(j,4)>0
            M_num_bax=A_Dynamic;%% If RNAP is present
        end
        if B(j,6)>0
            M_num_pai=A_Dynamic;%% If RNAP is present
        end
        if B(j,8)>0
            M_num_p48=A_Dynamic;%% If RNAP is present
        end

        %         M_stat=[qp53p21*Lambda_p53p21 exp(-eRp21/Temp) 0 0 0 exp(-ep21pai/Temp) 0 0; 0 qRp21*Lambda_Rp21 0 0 0 0 0 0;0 0 qp53bax*Lambda_p53bax exp(-eRbax/Temp) 0 0 0 0;0 0 0 qRbax*Lambda_Rbax 0 exp(-epaibax/Temp) 0 0;0 0 0 0 qp53pai*Lambda_p53pai exp(-eRpai/Temp) 0 0;0 0 0 0 0 qRpai*Lambda_Rpai 0 0;0 0 0 0 0 0 qp53p48*Lambda_p53p48 exp(-eRp48/Temp);0 0 0 0 0 0 0 qRp48*Lambda_Rp48 ];
        
        xi=A_Dynamic.*M_stat;
        xi(xi==0)=1;
        Zeta(1,j)=prod(prod(xi));
        %% p21
        num=M_num_p21.*M_stat;
        if sum(sum(num))==0
            num=0;
        else
            num(num==0)=1;
            num=prod(prod(num));
        end
        NUM_p21(1,j)=num;
        %% bax
        num=M_num_bax.*M_stat;
        if sum(sum(num))==0
            num=0;
        else
            num(num==0)=1;
            num=prod(prod(num));
        end
        NUM_bax(1,j)=num;
        %% pai
        num=M_num_pai.*M_stat;
        if sum(sum(num))==0
            num=0;
        else
            num(num==0)=1;
            num=prod(prod(num));
        end
        NUM_pai(1,j)=num;
        %% p48
        num=M_num_p48.*M_stat;
        if sum(sum(num))==0
            num=0;
        else
            num(num==0)=1;
            num=prod(prod(num));
        end
        NUM_p48(1,j)=num;
    end
    Denominator=sum(Zeta);
    Numerator_p21=sum(NUM_p21);
    Numerator_bax=sum(NUM_bax);
    Numerator_pai=sum(NUM_pai);
    Numerator_p48=sum(NUM_p48);
    DR_p21(1,q)=(Numerator_p21/Denominator)/((qRp21*Lambda_Rp21)/(1+qRp21*Lambda_Rp21));
    DR_bax(1,q)=(Numerator_bax/Denominator)/((qRp21*Lambda_Rbax)/(1+qRbax*Lambda_Rbax));
    DR_pai(1,q)=(Numerator_pai/Denominator)/((qRpai*Lambda_Rpai)/(1+qRpai*Lambda_Rpai));
    DR_p48(1,q)=(Numerator_p48/Denominator)/((qRp48*Lambda_Rp48)/(1+qRp48*Lambda_Rp48));
end
figure(1)
plot(log(P53),DR_p48,'g','Linewidth',2)
hold on
plot(log(P53),DR_p21,'b','Linewidth',2)
hold on
plot(log(P53),DR_bax,'r','Linewidth',2)
hold on
plot(log(P53),DR_pai,'y','Linewidth',2)
hold on
legend('p48 gene','p21 gene','Bax gene','PAI gene')
xlabel('log(\lambda_{p_{53}})')
ylabel('FC')
title('Cell fate in absence of interim genetic networks')