clear all
clc
fileID1=fopen('c_Simulation.out','w');
syms qp53p21 Lambda_p53p21 eRp21 Temp ep21pai  qRp21 Lambda_Rp21  qp53bax Lambda_p53bax  eRbax qRbax Lambda_Rbax epaibax qp53pai Lambda_p53pai eRpai qRpai Lambda_Rpai qp53p48 Lambda_p53p48  eRp48 qRp48 Lambda_Rp48
% fileID1=fopen('NEWProDNA_1_epd_6kT_Fraction.out','w');
% Simulation parameters
lseg=18;  %length of segment
nseg=10;
Lx = nseg*lseg;   Ly=1;          % Number of sites on one side of the lattice
latticed=ones(1,Lx);
occd=latticed';
nSites = Lx*Ly;     % Total number of sites
Temp = 0.53;        % Temperature
nSteps=25000;      % Number of MC sweeps
KdA_p21=4.9;KdA_bax=100;
KdA_pai=9.2;KdA_p48=21;
KdR_p21=20;KdR_bax=20;KdR_pai=20;KdR_p48=20;
activityR=10^-4;
Lambda_Rp21=activityR;Lambda_Rp48=activityR;Lambda_Rpai=activityR;Lambda_Rbax=activityR;
p=[];f_p21=[];f_p48=[];f_PAI=[];f_Bax=[];

eA_p21=-Temp*log(1/KdA_p21);eR_p21=-Temp*log(1/KdR_p21);qp53p21=exp(-eA_p21/Temp);qRp21=exp(-eR_p21/Temp);
eA_bax=-Temp*log(1/KdA_bax);eR_bax=-Temp*log(1/KdR_p48);qp53bax=exp(-eA_bax/Temp);qRbax=exp(-eR_bax/Temp);
eA_p48=-Temp*log(1/KdA_p48);eR_p48=-Temp*log(1/KdR_p48);qp53p48=exp(-eA_p48/Temp);qRp48=exp(-eR_p48/Temp);
eA_pai=-Temp*log(1/KdA_pai);eR_pai=-Temp*log(1/KdR_pai);qp53pai=exp(-eA_pai/Temp);qRpai=exp(-eR_pai/Temp);

eRp21=-3*Temp;wRp21=exp(-eRp21/Temp);
eRbax=-3*Temp;
wRbax=exp(-eRbax/Temp);
eRpai=-3*Temp;wRpai=exp(-eRpai/Temp);

ep21pai=0*Temp;
epaibax=0*Temp;
ep21bax=0*Temp;
ep21p48=0*Temp;
eRp48=-3*Temp;wRp48=exp(-eRp48/Temp);
q=0;
for activityp53=10.^(-3:0.2:6)
    q=q+1;
    P53(1,q)=activityp53;    
    Lambda_p53p21=activityp53;Lambda_p53bax=activityp53;Lambda_p53pai=activityp53;Lambda_p53p48=activityp53;  
    % Occupancy array - occ(x,y) == 1 if lattice site x,y is occupied by a particle 
    occp21= zeros(Lx,Ly);np21=sum(occp21); occR_p21= zeros(Lx,Ly);nR_p21=sum(occR_p21);
    occbax= zeros(Lx,Ly);nbax=sum(occbax); occR_bax= zeros(Lx,Ly);nR_bax=sum(occR_bax);
    occpai= zeros(Lx,Ly);npai=sum(occpai); occR_pai= zeros(Lx,Ly);nR_pai=sum(occR_pai);
    occp48= zeros(Lx,Ly);np48=sum(occp48); occR_p48= zeros(Lx,Ly);nR_p48=sum(occR_p48);
    
    
    U=0;
    sampleCount = 0;    % Will hold the number of times phi was sampled
    nAddRemSteps=100;
    % ==============
    % MC Simulation
    % ==============
    for step = 1:nSteps
        for subStep = 1:nAddRemSteps
            if (rand < 0.5)
                % Add a particle
                %% Add 1-Component (1a) p21
                % Chose a lattice site for the new particle
                xp = ceil(rand*Lx);yp = ceil(rand*Ly);
                if (occp21(xp,yp)<1)%A
                    deltaU=eA_p21+eRp21*occR_p21(xp,yp);
                    if (rand < exp(-deltaU/Temp)*activityp53*nSites/(np21+1))
                        % Accepted the Add move
                        U = U + deltaU;             % Update the potential energy
                        np21 = np21 + 1;          % Update number of particles
                        occp21(xp,yp) =occp21(xp,yp)+ 1;      % Mark lattice site as occupied
                    end
                end
                %% Add 1-Component (1a) R_p21
                % Chose a lattice site for the new particle
                xp = ceil(rand*Lx);yp = ceil(rand*Ly);
                if (occR_p21(xp,yp)<1)%A
                    deltaU=eR_p21+eRp21*occp21(xp,yp)+ep21bax*occR_bax(xp,yp)+ep21pai*occR_pai(xp,yp)+ep21p48*occR_p48(xp,yp);
                    if (rand < exp(-deltaU/Temp)*activityR*nSites/(nR_p21+1))
                        % Accepted the Add move
                        U = U + deltaU;             % Update the potential energy
                        nR_p21 = nR_p21 + 1;          % Update number of particles
                        occR_p21(xp,yp) =occR_p21(xp,yp)+ 1;      % Mark lattice site as occupied
                    end
                end
                %% Add 1-Component (2a) bax
                % Chose a lattice site for the new particle
                xp = ceil(rand*Lx);yp = ceil(rand*Ly);
                if (occbax(xp,yp)<1)%A
                    deltaU=eA_bax+eRbax*occR_bax(xp,yp);
                    if (rand < exp(-deltaU/Temp)*activityp53*nSites/(nbax+1))
                        % Accepted the Add move
                        U = U + deltaU;             % Update the potential energy
                        nbax = nbax + 1;          % Update number of particles
                        occbax(xp,yp) =occbax(xp,yp)+ 1;      % Mark lattice site as occupied
                    end
                end
                %% Add 1-Component (2a) bax
                % Chose a lattice site for the new particle
                xp = ceil(rand*Lx);yp = ceil(rand*Ly);
                if (occR_bax(xp,yp)<1)%A
                    deltaU=eR_bax+eRbax*occbax(xp,yp)+ep21bax*occR_p21(xp,yp)+epaibax*occR_pai(xp,yp);
                    if (rand < exp(-deltaU/Temp)*activityR*nSites/(nR_bax+1))
                        % Accepted the Add move
                        U = U + deltaU;             % Update the potential energy
                        nR_bax = nR_bax + 1;          % Update number of particles
                        occR_bax(xp,yp) =occR_bax(xp,yp)+ 1;      % Mark lattice site as occupied
                    end
                end
                 %% Add 1-Component (3a) pai
                % Chose a lattice site for the new particle
                xp = ceil(rand*Lx);yp = ceil(rand*Ly);
                if (occpai(xp,yp)<1)%A
                    deltaU=eA_pai+eRpai*occR_pai(xp,yp);
                    if (rand < exp(-deltaU/Temp)*activityp53*nSites/(npai+1))
                        % Accepted the Add move
                        U = U + deltaU;             % Update the potential energy
                        npai = npai + 1;          % Update number of particles
                        occpai(xp,yp) =occpai(xp,yp)+ 1;      % Mark lattice site as occupied
                    end
                end
                %% Add 1-Component (3a) pai
                % Chose a lattice site for the new particle
                xp = ceil(rand*Lx);yp = ceil(rand*Ly);
                if (occR_pai(xp,yp)<1)%A
                    deltaU=eR_pai+eRpai*occpai(xp,yp)+ep21pai*occR_p21(xp,yp)++epaibax*occR_bax(xp,yp);
                    if (rand < exp(-deltaU/Temp)*activityR*nSites/(nR_pai+1))
                        % Accepted the Add move
                        U = U + deltaU;             % Update the potential energy
                        nR_pai = nR_pai + 1;          % Update number of particles
                        occR_pai(xp,yp) =occR_pai(xp,yp)+ 1;      % Mark lattice site as occupied
                    end
                end
                %% Add 1-Component (4a) p48
                % Chose a lattice site for the new particle
                xp = ceil(rand*Lx);yp = ceil(rand*Ly);
                if (occp48(xp,yp)<1)%A
                    deltaU=eA_p48+eRp48*occR_p48(xp,yp);
                    if (rand < exp(-deltaU/Temp)*activityp53*nSites/(np48+1))
                        % Accepted the Add move
                        U = U + deltaU;             % Update the potential energy
                        np48 = np48 + 1;          % Update number of particles
                        occp48(xp,yp) =occp48(xp,yp)+ 1;      % Mark lattice site as occupied
                    end
                end
                %% Add 1-Component (4a) p48
                % Chose a lattice site for the new particle
                xp = ceil(rand*Lx);yp = ceil(rand*Ly);
                if (occR_p48(xp,yp)<1)%A
                    deltaU=eR_p48+eRp48*occp48(xp,yp)+ep21p48*occR_p21(xp,yp);
                    if (rand < exp(-deltaU/Temp)*activityR*nSites/(nR_p48+1))
                        % Accepted the Add move
                        U = U + deltaU;             % Update the potential energy
                        nR_p48 = nR_p48 + 1;          % Update number of particles
                        occR_p48(xp,yp) =occR_p48(xp,yp)+ 1;      % Mark lattice site as occupied
                    end
                end

            else 
                %% DEL 1-COMPONENT (1) p21
                % Remove a particle
                if (np21 > 0) % Make sure there are any particles to remove
                    part=find(occp21);
                    partpX=part(ceil(rand*length(part)));
                    partpY=ceil(rand*Ly);
                    if occp21(partpX,partpY)>0
                        deltaU =-eA_p21-eRp21*occR_p21(partpX,partpY);
                        if (rand < exp(-deltaU/Temp)*np21/(nSites*activityp53))
                            % Accepted the Remove move
                            U = U + deltaU;                     % Update the potential energy
                            occp21(partpX,partpY) =occp21(partpX,partpY)-1;               % Empty the lattice cell it was in
                            np21 = np21 - 1;                  % Update number of particles
                        end
                    end
                end
                %% DEL 1-COMPONENT (2) R_p21
                % Remove a particle
                if (nR_p21 > 0) % Make sure there are any particles to remove
                    part=find(occR_p21);
                    partpX=part(ceil(rand*length(part)));
                    partpY=ceil(rand*Ly);
                    if occR_p21(partpX,partpY)>0
                        deltaU =-eR_p21-eRp21*occp21(partpX,partpY)-ep21bax*occR_bax(partpX,partpY)-ep21pai*occR_pai(partpX,partpY)-ep21p48*occR_p48(partpX,partpY);
                        if (rand < exp(-deltaU/Temp)*nR_p21/(nSites*activityR))
                            % Accepted the Remove move
                            U = U + deltaU;                     % Update the potential energy
                            occR_p21(partpX,partpY)=occR_p21(partpX,partpY)-1;               % Empty the lattice cell it was in
                            nR_p21 = nR_p21- 1;                  % Update number of particles
                        end
                    end
                end 
                %% DEL 1-COMPONENT (3) bax
                % Remove a particle
                if (nbax > 0) % Make sure there are any particles to remove
                    part=find(occbax);
                    partpX=part(ceil(rand*length(part)));
                    partpY=ceil(rand*Ly);
                    if occbax(partpX,partpY)>0
                        deltaU =-eA_bax-eRbax*occR_bax(partpX,partpY);
                        if (rand < exp(-deltaU/Temp)*nbax/(nSites*activityp53))
                            % Accepted the Remove move
                            U = U + deltaU;                     % Update the potential energy
                            occbax(partpX,partpY) =occbax(partpX,partpY)-1;               % Empty the lattice cell it was in
                            nbax = nbax - 1;                  % Update number of particles
                        end
                    end
                end
                %% DEL 1-COMPONENT (4) R_bax
                % Remove a particle
                if (nR_bax > 0) % Make sure there are any particles to remove
                    part=find(occR_bax);
                    partpX=part(ceil(rand*length(part)));
                    partpY=ceil(rand*Ly);
                    if occR_bax(partpX,partpY)>0
                        deltaU =-eR_bax-eRbax*occbax(partpX,partpY)-ep21bax*occR_p21(partpX,partpY)-epaibax*occR_pai(partpX,partpY);
                        if (rand < exp(-deltaU/Temp)*nR_bax/(nSites*activityR))
                            % Accepted the Remove move
                            U = U + deltaU;                     % Update the potential energy
                            occR_bax(partpX,partpY)=occR_bax(partpX,partpY)-1;               % Empty the lattice cell it was in
                            nR_bax = nR_bax- 1;                  % Update number of particles
                        end
                    end
                end
                %% DEL 1-COMPONENT (5) pai
                % Remove a particle
                if (npai > 0) % Make sure there are any particles to remove
                    part=find(occpai);
                    partpX=part(ceil(rand*length(part)));
                    partpY=ceil(rand*Ly);
                    if occpai(partpX,partpY)>0
                        deltaU =-eA_pai-eRpai*occR_pai(partpX,partpY);
                        if (rand < exp(-deltaU/Temp)*npai/(nSites*activityp53))
                            % Accepted the Remove move
                            U = U + deltaU;                     % Update the potential energy
                            occpai(partpX,partpY) =occpai(partpX,partpY)-1;               % Empty the lattice cell it was in
                            npai = npai - 1;                  % Update number of particles
                        end
                    end
                end
                %% DEL 1-COMPONENT (6) R_pai
                % Remove a particle
                if (nR_pai > 0) % Make sure there are any particles to remove
                    part=find(occR_pai);
                    partpX=part(ceil(rand*length(part)));
                    partpY=ceil(rand*Ly);
                    if occR_pai(partpX,partpY)>0
                        deltaU =-eR_pai-eRpai*occpai(partpX,partpY)-ep21pai*occR_p21(partpX,partpY)-epaibax*occR_bax(partpX,partpY);
                        if (rand < exp(-deltaU/Temp)*nR_pai/(nSites*activityR))
                            % Accepted the Remove move
                            U = U + deltaU;                     % Update the potential energy
                            occR_pai(partpX,partpY)=occR_pai(partpX,partpY)-1;               % Empty the lattice cell it was in
                            nR_pai = nR_pai- 1;                  % Update number of particles
                        end
                    end
                end
                %% DEL 1-COMPONENT (7) p48
                % Remove a particle
                if (np48 > 0) % Make sure there are any particles to remove
                    part=find(occp48);
                    partpX=part(ceil(rand*length(part)));
                    partpY=ceil(rand*Ly);
                    if occp48(partpX,partpY)>0
                        deltaU =-eA_p48-eRp48*occR_p48(partpX,partpY);
                        if (rand < exp(-deltaU/Temp)*np48/(nSites*activityp53))
                            % Accepted the Remove move
                            U = U + deltaU;                     % Update the potential energy
                            occp48(partpX,partpY) =occp48(partpX,partpY)-1;               % Empty the lattice cell it was in
                            np48 = np48 - 1;                  % Update number of particles
                        end
                    end
                end
                %% DEL 1-COMPONENT (8) R_p48
                % Remove a particle
                if (nR_p48 > 0) % Make sure there are any particles to remove
                    part=find(occR_p48);
                    partpX=part(ceil(rand*length(part)));
                    partpY=ceil(rand*Ly);
                    if occR_p48(partpX,partpY)>0
                        deltaU =-eR_p48-eRp48*occp48(partpX,partpY)-ep21p48*occR_p21(partpX,partpY);
                        if (rand < exp(-deltaU/Temp)*nR_p48/(nSites*activityR))
                            % Accepted the Remove move
                            U = U + deltaU;                     % Update the potential energy
                            occR_p48(partpX,partpY)=occR_p48(partpX,partpY)-1;               % Empty the lattice cell it was in
                            nR_p48 = nR_p48- 1;                  % Update number of particles
                        end
                    end
                end
            end
        end
        
        NEWS(step,1)=U;
        NP_bax(1,step)=sum(occR_bax);
        NP_p21(1,step)=sum(occR_p21);
        NP_p48(1,step)=sum(occR_p48);
        NP_PAI(1,step)=sum(occR_pai);
    end
    disp(q)
    figure(1)
    plot(NEWS)
    hold on
    avphi_BAX=NP_bax./nSites;
    avphi_p21=NP_p21./nSites;
    
    avphi_p48=NP_p48./nSites;
    avphi_PAI=NP_PAI./nSites;
DR_BAX(1,q)=sum(avphi_BAX)/nSteps;
DR_p21(1,q)=sum(avphi_p21)/nSteps;
DR_p48(1,q)=sum(avphi_p48)/nSteps;
DR_PAI(1,q)=sum(avphi_PAI)/nSteps;
fprintf(fileID1,'%f %f %f %f %g\t',log(P53(1,q)),DR_BAX(1,q)/(qRbax*Lambda_Rbax/(1+qRbax*Lambda_Rbax)),DR_p21(1,q)/(qRp21*Lambda_Rp21/(1+qRp21*Lambda_Rp21)),DR_p48(1,q)/(qRp48*Lambda_Rp48/(1+qRp48*Lambda_Rp48)),DR_PAI(1,q)/(qRpai*Lambda_Rpai/(1+qRpai*Lambda_Rpai)));
fprintf(fileID1,'\n');
end
figure(3)
plot(log(P53),DR_BAX/(qRbax*Lambda_Rbax/(1+qRbax*Lambda_Rbax)),'ro','Linewidth',2)
hold on
plot(log(P53),DR_p21/(qRp21*Lambda_Rp21/(1+qRp21*Lambda_Rp21)),'bo','Linewidth',2)
hold on
plot(log(P53),DR_p48/(qRp48*Lambda_Rp48/(1+qRp48*Lambda_Rp48)),'go','Linewidth',2)
hold on
plot(log(P53),DR_PAI/(qRpai*Lambda_Rpai/(1+qRpai*Lambda_Rpai)),'yo','Linewidth',2)
hold on
xlabel('\lambda_{p53}')
ylabel('\theta')
legend('Bax gene','p21 gene','p48 gene','PAI gene')