from gpaw import GPAW, FD, restart, setup_paths
from gpaw.directmin.etdm_fdpw import FDPWETDM
from gpaw.mom import prepare_mom_calculation
from gpaw.directmin.tools import excite
import numpy as np

setup_paths.insert(0, '/users/home/aes38/basissets/')

atoms, calc = restart('../triplet.gpw', txt = 'mixed.txt')
calc.wfs.initialize_wave_functions_from_restart_file()
# f_n = [calc.wfs.kpt_u[x].f_n.copy() for x in range(len(calc.wfs.kpt_u))]
psit_nG = [calc.wfs.kpt_u[x].psit_nG.copy() for x in range(len(calc.wfs.kpt_u))]
f_n = excite(calc, 0, -2, (1, 0))
print(f_n)
prepare_mom_calculation(calc, atoms, f_n)

calc.set(eigensolver=FDPWETDM(excited_state=True, functional='PZ-SIC', printinnerloop=True),
        maxiter=1000,
        mode=FD(force_complex_dtype=True),
        convergence={'eigenstates': 1e-6})

calc.initialize(atoms)
calc.set_positions(atoms)

for i, psit in enumerate(psit_nG):
    for k, band in enumerate(psit):
        calc.wfs.kpt_u[i].psit_nG.real[k] = band.real
        calc.wfs.kpt_u[i].psit_nG.imag[k] = band.imag
    calc.wfs.kpt_u[i].f_n = f_n[i]

calc.wfs.kpt_u[0].psit_nG[3] = psit_nG[1][4]

# prepare_mom_calculation(calc, atoms, f_n)
calc.calculate(system_changes=None)
calc.write('mixed.gpw', mode = 'all')


