from gpaw import GPAW, restart, setup_paths
from gpaw.directmin.tools import excite
from gpaw.directmin.lcao_etdm import LCAOETDM
from gpaw.mom import prepare_mom_calculation
import numpy as np

setup_paths.insert(0, '/users/home/aes38/basissets/')

atoms, calc = restart('../../ground.gpw', txt = 'mixed.txt')
calc.calculate(properties=['energy'], system_changes=['positions'])

f_sn = excite(calc, 0, 2, (0, 0))

calc.set(eigensolver=LCAOETDM(excited_state=True,
        partial_diagonalizer={
            'name': 'Davidson', 'logfile': 'davidson.txt', 'm': 150, 'fd_mode': 'central',
            'h': 1e-3, 'eps': 1e-2, 'sp_order': 4, 'cap_krylov': False,
            'accurate_first_pdiag': False},
        linesearch_algo={'name': 'max-step'},
        searchdir_algo={'name': 'LBFGS-P_GMF'},))

prepare_mom_calculation(calc, atoms, f_sn)

e = atoms.get_potential_energy()
calc.write('mixed.gpw', mode = 'all')

