from gpaw import restart
from gpaw.directmin.fdpw.directmin import DirectMin
from gpaw.directmin.tools import excite_and_sort
import numpy as np

atoms, calc = restart('../ground.gpw')
calc.wfs.eigensolver.lsa = {'name': 'max-step', 'max_step': 0.0}
calc.scf.criteria['eigenstates'].tol = np.inf
calc.calculate(system_changes=None)

excite_and_sort(calc.wfs, 0, 3, (0, 1))
f_sn = []
for spin in range(calc.get_number_of_spins()):
    f_n = calc.get_occupation_numbers(spin=spin)
    f_sn.append(f_n)

calc.set(eigensolver=DirectMin(
         maxiterxst=100,
         xstlogfile='innerloopt.txt',
         g_tolxst=1e-3,
         need_init_orbs=False,
         exstopt=True),
         txt='triplet.txt',
         occupations={'name': 'mom', 'numbers': f_sn,
                      'use_fixed_occupations': True})

atoms.get_potential_energy()

calc.write('triplet.gpw', mode='all')
