from gpaw import GPAW, FD, setup_paths
from ase.io import read
from gpaw.directmin.fdpw.directmin import DirectMin
from gpaw.directmin.tools import excite
from gpaw.directmin.derivatives import Davidson
from gpaw.mixer import DummyMixer
from gpaw.xc import XC

atoms = read('../../h2o.xyz')
atoms.center(vacuum=10.0)

mode = FD(force_complex_dtype=True) 
# setup_paths.insert(0, '/users/home/aes38/basissets/')

calc = GPAW(mode='fd',
        h=0.15,
        xc='PBE',
        maxiter=1000,
        spinpol=True,
        eigensolver='cg',
        occupations={'name': 'fixed-uniform'},
        nbands=-10,
        symmetry='off',
        txt='ground.txt')

atoms.calc = calc
atoms.get_potential_energy()

calc.set(eigensolver=DirectMin(),
        mixer={'name': 'dummy'})

atoms.get_potential_energy()

calc.write('ground.gpw', mode='all')

