import copy
import numpy as np
# from ase.build import atomsecule
from ase.optimize import LBFGS
from ase.parallel import paropen, parprint
from ase.io import read, write
from ase.db import connect
from gpaw import GPAW, restart, LCAO, setup_paths
from gpaw.mixer import DummyMixer
from gpaw.mom import prepare_mom_calculation
from gpaw.directmin.etdm import ETDM
from gpaw.directmin.tools import excite
from gpaw.directmin.derivatives import Davidson
#from gpaw.directmin.fdpw.directmin import DirectMin
#from gpaw.directmin.fdpw.directmin import DirectMin
from gpaw.xc import XC
#from gpaw.directmin.exstatetools import excite_and_sort

# np.random.seed(0)

setup_paths.insert(0, '/users/home/aes38/basissets/')

atoms, calc = restart('../ground.gpw')
calc.calculate(properties=['energy'], system_changes=['positions'])
calc.set(txt='triplet.txt')

f_sn = excite(calc, 0, 3, spin=(0, 1))
for k, kpt in enumerate(calc.wfs.kpt_u):
    kpt.f_n = f_sn[k]  # Set occupation numbers in wave function

#dave = Davidson(calc.wfs.eigensolver, None)
appr_sp_order = 3

calc.set(eigensolver=ETDM(
         partial_diagonalizer={
             'name': 'Davidson', 'logfile': None, 'm': 10 * appr_sp_order,
             'remember_sp_order': True, 'sp_order': appr_sp_order},
         linesearch_algo={'name': 'max-step'},
         searchdir_algo={'name': 'LBFGS-P_GMF'},
         need_init_orbs=False),
         # MOM is not needed for GMF. This just prepares fixed occupation
         # numbers
         occupations={'name': 'mom', 'numbers': f_sn,
                      'use_fixed_occupations': True})

E_t = atoms.get_potential_energy()

calc.write('triplet.gpw', mode='all')

