from gpaw import GPAW, restart, setup_paths
from gpaw.directmin.tools import excite
from gpaw.directmin.etdm import ETDM
import numpy as np

setup_paths.insert(0, '/users/home/aes38/basissets/')

atoms, calc = restart('../ground.gpw', txt = 'mixed.txt')
calc.calculate(properties=['energy'], system_changes=['positions'])

f_sn = excite(calc, -1, 0, (0, 0))

calc.set(eigensolver=ETDM(
         searchdir_algo='l-sr1-p',
         linesearch_algo='max-step',
         need_init_orbs=False),
         occupations={'name': 'mom', 'numbers': f_sn})

e = atoms.get_potential_energy()
calc.write('mixed.gpw', mode = 'all')

