from gpaw import GPAW, FD, restart, setup_paths
from gpaw.directmin.etdm_fdpw import FDPWETDM
from gpaw.directmin.tools import excite
from gpaw.mom import prepare_mom_calculation
import numpy as np

setup_paths.insert(0, '/users/home/aes38/basissets/')

atoms, calc = restart('../ground.gpw', txt='mixed.txt')
calc.wfs.initialize_wave_functions_from_restart_file()

f_n = excite(calc, 0, 1, (0, 0))
nbands = calc.get_number_of_bands()

ratoms, rcalc = restart('../ion.gpw')
rcalc.wfs.initialize_wave_functions_from_restart_file()

psit_nG = [rcalc.wfs.kpt_u[x].psit_nG.copy() for x in range(len(rcalc.wfs.kpt_u))]

calc.set(eigensolver=FDPWETDM(excited_state=True))

for k, kpt in enumerate(calc.wfs.kpt_u):
    for p, psit in enumerate(kpt.psit_nG):
        psit = psit_nG[k][p]


prepare_mom_calculation(calc, atoms, f_n)

calc.calculate(properties=['energy'], system_changes=None)
calc.write('mixed.gpw', mode = 'all')


