from gpaw import GPAW, FD, restart, setup_paths
from gpaw.directmin.tools import excite
from gpaw.directmin.etdm_fdpw import FDPWETDM
from gpaw.mom import prepare_mom_calculation
import numpy as np

setup_paths.insert(0, '/users/home/aes38/basissets/')

atoms, calc = restart('../ground.gpw', txt = 'triplet.txt')
calc.wfs.initialize_wave_functions_from_restart_file()
# f_n = [calc.wfs.kpt_u[x].f_n.copy() for x in range(len(calc.wfs.kpt_u))]
psit_nG = [calc.wfs.kpt_u[x].psit_nG.copy() for x in range(len(calc.wfs.kpt_u))]

calc.set(eigensolver=FDPWETDM(excited_state=True, printinnerloop=True),
        maxiter=1000,
        charge=0,
        convergence={'eigenstates': 1e-6})

calc.initialize(atoms)
calc.set_positions(atoms)

for i, psit in enumerate(psit_nG):
    for k, band in enumerate(psit):
        calc.wfs.kpt_u[i].psit_nG[k] = band

f_sn = excite(calc, 0, 1, (0, 1))

prepare_mom_calculation(calc, atoms, f_n)
calc.calculate(system_changes=None)
calc.write('triplet.gpw', mode = 'all')


