from gpaw import GPAW, LCAO, setup_paths
from ase.io import read
from gpaw.directmin.etdm import ETDM
from gpaw.directmin.tools import excite
from gpaw.directmin.derivatives import Davidson
from gpaw.mixer import DummyMixer
from gpaw.xc import XC

atoms = read('../../../h2co.xyz')
atoms.center(vacuum=10.0)
im = atoms.get_initial_magnetic_moments()
im[0] = 2
atoms.set_initial_magnetic_moments(im)

# mode = LCAO(force_complex_dtype=True)
setup_paths.insert(0, '/users/home/aes38/basissets/')

calc = GPAW(mode='lcao',
        basis='aug-cc-pVDZ_PBE.sz',
        h=0.15,
        xc='PBE',
        maxiter=1000,
        mixer={'backend': 'no-mixing'},
        spinpol=True,
        eigensolver=ETDM(),
        occupations={'name': 'fixed-uniform'},
        nbands='nao',
        symmetry='off',
        txt='triplet.txt')

atoms.calc = calc
atoms.get_potential_energy()

calc.write('triplet.gpw', mode='all')

