from gpaw import restart
from gpaw.directmin.fdpw.directmin import DirectMin
from gpaw.directmin.tools import excite_and_sort
import numpy as np

atoms, calc = restart('../ground.gpw')
calc.calculate(system_changes=None)

excite_and_sort(calc.wfs, 0, 1, (0, 0))
f_sn = []
for spin in range(calc.get_number_of_spins()):
    f_n = calc.get_occupation_numbers(spin=spin)
    f_sn.append(f_n)

calc.set(eigensolver=DirectMin(
         partial_diagonalizer={
             'name': 'Davidson', 'logfile': 'davidson.txt', 'm': 40,
             'cap_krylov': False, 'eps': 1e-2, 'h': 1e-3, 'sp_order': 4},
         maxiterxst=np.inf,
         xstlogfile='innerloop.txt',
         #g_tolxst=1e-3,
         egdecomp=False,
         need_init_orbs=False,
         exstopt=True),
         txt='mixed.txt',
         occupations={'name': 'mom', 'numbers': f_sn,
                      'use_fixed_occupations': True})

atoms.get_potential_energy()

calc.write('mixed.gpw', mode='all')
