from gpaw import GPAW, restart, setup_paths
from gpaw.directmin.tools import excite
from gpaw.directmin.etdm_fdpw import FDPWETDM
from gpaw.mom import prepare_mom_calculation
import numpy as np

setup_paths.insert(0, '/users/home/aes38/basissets/')

atoms, calc = restart('../triplet.gpw', txt = 'mixed.txt')
# calc.calculate(properties=['energy'], system_changes=['positions'])
calc.wfs.initialize_wave_functions_from_restart_file()

f_sn = excite(calc, 2, 2, (1, 0))

calc.set(eigensolver=FDPWETDM(excited_state=True), convergence={'eigenstates': 1e-6})

prepare_mom_calculation(calc, atoms, f_sn)

band = calc.wfs.kpt_u[1].psit_nG[8].copy()
calc.wfs.kpt_u[0].psit_nG[9] = band

e = atoms.get_potential_energy()
calc.write('mixed.gpw', mode = 'all')

