from gpaw import GPAW, FD, restart, setup_paths
from gpaw.directmin.etdm_fdpw import FDPWETDM
from gpaw.mom import prepare_mom_calculation
import numpy as np

setup_paths.insert(0, '/users/home/aes38/basissets/')

atoms, calc = restart('/users/home/aes38/Rydberg/new/ethylene/complex/fd/ground.gpw', txt='triplet.txt')
calc.wfs.initialize_wave_functions_from_restart_file()

nbands = calc.get_number_of_bands()

ratoms, rcalc = restart('/users/home/aes38/Rydberg/new/ethylene/complex/sic/firstext/triplet.gpw')
rcalc.set_positions()
rcalc.wfs.initialize_wave_functions_from_lcao()

f_sn = [rcalc.wfs.kpt_u[x].f_n.copy() for x in range(len(rcalc.wfs.kpt_u))]
psit_nG = [rcalc.wfs.kpt_u[x].psit_nG.copy() for x in range(len(rcalc.wfs.kpt_u))]

calc.set(eigensolver=FDPWETDM(excited_state=True, functional='PZ-SIC', printinnerloop=True), convergence={'eigenstates': 1e-6})

for k, kpt in enumerate(calc.wfs.kpt_u):
    for i in range(len(kpt.psit_nG)):
        kpt.psit_nG[i] = psit_nG[k][i].copy()

f_n = [f_sn[x][:nbands] for x in range(len(f_sn))]

prepare_mom_calculation(calc, atoms, f_n)

calc.calculate(properties=['energy'], system_changes=None)
calc.write('triplet.gpw', mode = 'all')


