from gpaw import restart, setup_paths
from os.path import exists

setup_paths.insert(0, '/users/home/aes38/basissets/')

gatoms, gcalc = restart('ground.gpw')
E0 = gatoms.get_potential_energy()

n = ['firstext/', 'secondext/', 'thirdext/', 'fourthext/', 'fifthext/', 'sixthext/', 'seventhext/', 'eighthext/', 'ninthext/']

f = open('excitation_energies.txt', 'w')
f.write('State, Mixed, Corrected, Triplet')
f.write('\n')

for i in range(len(n)):
    if exists(n[i]) == False:
        continue
    if exists(n[i] + 'mixed.gpw'):
        matoms, mcalc = restart(n[i] + 'mixed.gpw')
        M = matoms.get_potential_energy()
    else:
        M = float('nan')
    if exists(n[i] + 'triplet.gpw'):
        tatoms, tcalc = restart(n[i] + 'triplet.gpw')
        T = tatoms.get_potential_energy()
    else:
        T = float('nan')
    f.write('LUMO + ' + str(i) +', ')
    f.write(str(M - E0) + ', ')
    f.write(str(2 * M - T - E0) + ', ')
    f.write(str(T - E0))
    f.write('\n')


f.close()
