from gpaw import GPAW, FD, restart, setup_paths
from gpaw.directmin.etdm_lcao import LCAOETDM
from gpaw.mom import prepare_mom_calculation
import numpy as np

setup_paths.insert(0, '/users/home/aes38/basissets/')

atoms, calc = restart('/users/home/aes38/Rydberg/new/ethylene/complex/lcao/seventhext/triplet.gpw', txt = 'triplet.txt')
f_n = [calc.wfs.kpt_u[x].f_n.copy() for x in range(len(calc.wfs.kpt_u))]

calc.set(eigensolver=LCAOETDM(excited_state=True, functional='PZ-SIC', localizationtype='PM_PZ'),
        maxiter=1000, convergence={'eigenstates': 1e-6})

prepare_mom_calculation(calc, atoms, f_n)
atoms.get_potential_energy()
calc.write('triplet.gpw', mode = 'all')


