from gpaw import GPAW, LCAO, setup_paths
from ase.io import read
from gpaw.directmin.lcao_etdm import LCAOETDM
from gpaw.directmin.tools import excite
from gpaw.directmin.derivatives import Davidson
from gpaw.mixer import DummyMixer
from gpaw.xc import XC

atoms = read('../../c2h4.xyz')
atoms.center(vacuum=10.0)

# mode = LCAO(force_complex_dtype=True) 
setup_paths.insert(0, '/users/home/aes38/basissets/')

calc = GPAW(mode=LCAO(force_complex_dtype=True),
        basis='aug-cc-pVDZ_PBE.sz',
        h=0.15,
        xc='PBE',
        maxiter=1000,
        mixer={'backend': 'no-mixing'},
        spinpol=True,
        eigensolver=LCAOETDM(),
        occupations={'name': 'fixed-uniform'},
        nbands='nao',
        symmetry='off',
        txt='ground.txt')

atoms.calc = calc
atoms.get_potential_energy()

calc.write('ground.gpw', mode='all')

