from gpaw import restart, setup_paths
from gpaw.directmin.derivatives import Davidson
from ase.parallel import parprint
import numpy as np

setup_paths.insert(0, '/users/home/aes38/basissets/')

atoms, calc = restart('mixed.gpw', txt = 'spmix.txt')
calc.wfs.eigensolver.lsa = {'name': 'max-step', 'max_step': 0.0}
calc.scf.criteria['eigenstates'].tol = np.inf
calc.calculate(properties=['energy'], system_changes=['positions'])

dave = Davidson(calc.wfs.eigensolver, 'davidsonmix.txt')
sp = dave.estimate_sp_order(calc, method = 'full-hess', target_more = 5)
parprint(sp)

