from gpaw import GPAW, FD, restart, setup_paths
from gpaw.directmin.etdm_fdpw import FDPWETDM
from gpaw.mom import prepare_mom_calculation
import numpy as np

setup_paths.insert(0, '/users/home/aes38/basissets/')

atoms, calc = restart('/users/home/aes38/Rydberg/new/ethylene/complex/fd/seventhext/mixed.gpw', txt = 'mixed.txt')
f_n = [calc.wfs.kpt_u[x].f_n.copy() for x in range(len(calc.wfs.kpt_u))]

calc.set(eigensolver=FDPWETDM(excited_state=True, functional='PZ-SIC', localizationtype='PM_PZ'),
        maxiter=1000)

prepare_mom_calculation(calc, atoms, f_n)
atoms.get_potential_energy()
calc.write('mixed.gpw', mode = 'all')


