from gpaw import GPAW, restart, setup_paths
from gpaw.directmin.tools import excite
from gpaw.directmin.etdm_fdpw import FDPWETDM
from gpaw.mom import prepare_mom_calculation
import numpy as np

setup_paths.insert(0, '/users/home/aes38/basissets/')

atoms, calc = restart('/users/home/aes38/Rydberg/new/ethylene/Real/thirdext/triplet.gpw', txt = 'triplet.txt')
# calc.calculate(properties=['energy'], system_changes=['positions'])
calc.wfs.initialize_wave_functions_from_restart_file()

calc.set(xc='TPSS', convergence={'eigenstates': 1e-6})

e = atoms.get_potential_energy()
calc.write('triplet.gpw', mode = 'all')

