from gpaw import GPAW, restart, setup_paths
from gpaw.directmin.tools import excite
from gpaw.directmin.etdm_fdpw import FDPWETDM
from gpaw.mom import prepare_mom_calculation
import numpy as np

setup_paths.insert(0, '/users/home/aes38/basissets/')

atoms, calc = restart('../mixed.gpw', txt = 'triplet.txt')
# calc.calculate(properties=['energy'], system_changes=['positions'])
calc.wfs.initialize_wave_functions_from_restart_file()
psit_nG = [calc.wfs.kpt_u[x].psit_nG.copy() for x in range(len(calc.wfs.kpt_u))]

f_sn = excite(calc, 3, 2, (0, 1))
print(f_sn)

calc.set(eigensolver=FDPWETDM(excited_state=True))

prepare_mom_calculation(calc, atoms, f_sn)
calc.wfs.kpt_u[1].psit_nG[8] = psit_nG[0][8]

calc.calculate(system_changes=None)
calc.write('triplet.gpw', mode = 'all')

