from gpaw import GPAW, FD, restart, setup_paths
from gpaw.directmin.etdm_fdpw import FDPWETDM
from gpaw.mom import prepare_mom_calculation
import numpy as np

setup_paths.insert(0, '/users/home/aes38/basissets/')

atoms, calc = restart('/users/home/aes38/Rydberg/new/ammonia/sicfromreal/thirdext/triplet.gpw', txt = 'triplet.txt')
calc.wfs.initialize_wave_functions_from_restart_file()
f_n = [calc.wfs.kpt_u[x].f_n.copy() for x in range(len(calc.wfs.kpt_u))]
psit_nG = [calc.wfs.kpt_u[x].psit_nG.copy() for x in range(len(calc.wfs.kpt_u))]

calc.set(eigensolver=FDPWETDM(excited_state=True))

prepare_mom_calculation(calc, atoms, f_n)

# prepare_mom_calculation(calc, atoms, f_n)
calc.calculate(system_changes=None)
calc.write('triplet.gpw', mode = 'all')


