from ase.io import write
from ase.units import Bohr
from gpaw import restart, setup_paths
import numpy as np

setup_paths.insert(0, '/users/home/aes38/basissets/')

atoms, calc = restart('fromsic/mixed.gpw')

dens = calc.get_all_electron_density(gridrefinement = 4)
write('round.cube', atoms, data=dens * Bohr ** 3)

atoms, calc = restart('yes/mixed.gpw')

dens = calc.get_all_electron_density(gridrefinement = 4)
write('asym.cube', atoms, data=dens * Bohr ** 3)


